% DUDE algorithm Proof-of-concept code
% Coded by Qun Feng Tan
close all
clear all
clc
p = 0.5; % Corruption probaility
pic = imread('einstein_bit.jpg');
height = size(pic,1);
width = size(pic,2);
pic_vec = pic(:);
pic_mean = mean(pic_vec);
B = pic_vec>pic_mean;
img_size = numel(pic);
%---Corrupting with noise------%
Y = xor(B,(rand(img_size,1)<p));
%------Edge padding------------%
window_size=9
Y1 = [Y(1)*ones((window_size-1)/2,1);Y;Y(img_size)*ones((window_size-1)/2,1)];
%----Implementing the DUDE algorithm------------%
%--First pass : Computation of empirical counts ---%
m_0=zeros(2^(window_size-1),1);
m_1=zeros(2^(window_size-1),1);
for i = (window_size-1)/2+1:size(Y)+(window_size-1)/2
    % get left and right context then concatenate them
    left_context='';
    right_context='';
    for j=1:(window_size-1)/2
        left_context=strcat(left_context,num2str(Y1(i-(window_size-1)/2+j-1)));
        right_context=strcat(right_context,num2str(Y1(i+j)));
    end
    left_right=strcat(left_context,right_context);
    if Y1(i)==1
        m_1(bin2dec(left_right)+1)=m_1(bin2dec(left_right)+1)+1;
    else
        m_0(bin2dec(left_right)+1)=m_0(bin2dec(left_right)+1)+1;
    end
end
%-------Second pass: DUDE denoising----------%
for i = (window_size-1)/2+1:size(Y)+(window_size-1)/2
    % get left and right context then concatenate them
    left_context='';
    right_context='';
    for j=1:(window_size-1)/2
        left_context=strcat(left_context,num2str(Y1(i-(window_size-1)/2+j-1)));
        right_context=strcat(right_context,num2str(Y1(i+j)));
    end
    left_right=strcat(left_context,right_context);
    index=bin2dec(left_right)+1;
    if Y1(i)==1
        if m_1(index)/(m_1(index)+m_0(index))>2*p*(1-p)
            output(i-(window_size-1)/2)=1;
        else
            output(i-(window_size-1)/2)=0;
        end
    else
        if m_0(index)/(m_1(index)+m_0(index))>2*p*(1-p)
            output(i-(window_size-1)/2)=0;
        else
            output(i-(window_size-1)/2)=1;
        end
    end
end
%---Reshaping image and compute error rate -----%
imshow(reshape(B,size(pic,1),size(pic,2)))
figure
imshow(reshape(Y,size(pic,1),size(pic,2)))
figure
imshow(reshape(output,size(pic,1),size(pic,2)));
orig_error_rate=mean(abs(B-Y))
post_error_rate=mean(abs(B-output'))
